% ALPHA ENGINE DEFINITION
% Generated 21-Mar-2023 13:58:51

% SUGGESTED CITATION:
% Toyota 2.5L TNGA Prototype Hybrid Engine from 2017 Vienna Paper - ALPHA Map Package. Version 2023-03. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'Toyota 2.5L TNGA Prototype Hybrid Engine from 2017 Vienna Paper Octane Modified for Tier 3 Fuel'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.5; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.inertia_kgm2 =  0.145; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     83.775804095727807	;     118.32968003379398	;     125.66370614359172	;     130.89969389957471	;     136.13568165555770	;     155.69378632099685	;     157.07963267948966	;     167.55160819145561	;     179.28676069523979	;     183.25957145940458	;     196.53452398248217	;     199.06269894523604	;     201.36054608615734	;     208.79508099315544	;     332.52549929353512	;     463.12982986715770	;     598.03035541520774	;     609.20046255815828	;     639.66048568606618	;     670.12050881397420		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     100.00000000000000	;     148.66986840296687	;     155.49378313787628	;     158.91482195752729	;     162.39360685934057	;     170.67075444718628	;     171.37012474763125	;     176.58722352545087	;     180.66207436623716	;     182.79156569586559	;     188.01903209102483	;     193.41741977023321	;     196.84267813404915	;     198.82113799999999	;     219.34959300000000	;     220.97560999999999	;     219.55284599999999	;     211.42276400000000	;     181.21951200000001	;     0.0000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     105.03391438501875	;     373.95424553230504	;     470.50585975263135	;     603.18578948924028	;     670.12050881397420		]; 
engine.closed_throttle_torque_Nm = [	    -15.948686146731134	;    -22.000000000000000	;    -31.699999999999999	;    -38.600000000000001	;    -50.700000000000003	;    -54.556306762306079		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	    52.359877559829883	    78.539816339744831	    104.71975511965977	    130.89969389957471	    157.07963267948966	    183.25957145940458	    209.43951023931953	    235.61944901923448	    261.79938779914943	    287.97932657906438	    314.15926535897933	    340.33920413889422	    366.51914291880917	    418.87902047863906	    471.23889803846896	    523.59877559829886	    575.95865315812875	    628.31853071795865	    680.67840827778844		]; 
engine.fuel_map_torque_Nm = [	    -57.284122100421385	;    -39.642061050210692	;    -22.000000000000000	;    -11.876016250000001	;    -1.7520325000000021	;     8.3719512499999986	;     18.495934999999996	;     28.619918750000004	;     38.743902499999997	;     48.867886249999998	;     58.991869999999992	;     69.115853749999999	;     79.239837500000007	;     89.363821250000001	;     99.487804999999994	;     109.61178874999999	;     119.73577250000000	;     129.85975625000000	;     139.98373999999998	;     150.10772374999999	;     160.23170750000000	;     170.35569124999998	;     180.47967500000001	;     190.60365874999999	;     200.72764250000000	;     210.85162624999998	;     220.97560999999999	;     232.02439050000001		]; 
engine.fuel_map_gps = [
 -0.043624377553855474	  -0.18174074145323671	  -0.21950527268256353	  -0.23946997012840743	  -0.25697703458778709	  -0.27195301120545917	  -0.28458118418588640	  -0.29524123613883169	  -0.30435512451134622	  -0.31226315779094543	  -0.31917322920717933	  -0.32516876522319249	  -0.33024621153946876	  -0.33435960744169935	  -0.33803007081950653	  -0.33328407411402011	  -0.32064068739733143	  -0.30116864365763846	  -0.27657454683545013	  -0.24985178839509611	;
 -0.023041747965371395	  -0.10121586538251302	  -0.11079472464567883	  -0.11727225053548078	  -0.11914991000254006	  -0.11704397859995508	  -0.11210532642629122	  -0.10507556874186480	 -0.096215473019120132	 -0.085533151227121629	 -0.072972967000583810	 -0.058498525267392930	 -0.042111105108521209	 -0.023850781183552546	  0.020707470401160617	  0.077116262882348047	   0.14092687938448525	   0.20641636271572408	   0.27022393280866236	   0.33183100414768307	;
-0.0058002247569121299	-0.0015156097088737529	 0.0024200918666213702	 0.0069703181657524340	  0.022106886904766181	  0.040488660150735011	  0.060935263632060553	  0.083999383526030494	   0.11015529708130208	   0.13953415459984170	   0.17206535469492457	   0.20760522469947099	   0.24599052068635605	   0.28704139622506691	   0.38014248936168493	   0.48797552003971312	   0.60302701227464239	   0.71507572342571202	   0.81630043913314176	   0.91173655157551625	;
 0.0029606131511312641	  0.051849910249556048	  0.072658209026764856	  0.089760150578256884	   0.10814314613827775	   0.13081141330787410	   0.15835417637230051	   0.19052638756628926	   0.22702237098105707	   0.26759975651092577	   0.31203482872024141	   0.36009172370980441	   0.41151693165664260	   0.46603245894421219	   0.58749817705281271	   0.72445335969898572	   0.86788311137971630	    1.0068927080106707	    1.1283492688884951	    1.2439079579001915	;
  0.019120735303374745	  0.095910174845772370	   0.13646455416548678	   0.16387283100594296	   0.18852253885667047	   0.21827362956872209	   0.25425089528681799	   0.29601611820614548	   0.34306805879723240	   0.39503893071192986	   0.45161717520035716	   0.51248087502507833	   0.57727260783366585	   0.64558684249780873	   0.79593593504621174	   0.96171600200014906	    1.1321943699593831	    1.2973624204858667	    1.4393035331754582	    1.5762854570008875	;
  0.029864851700431856	   0.12526358540817789	   0.17435214418813363	   0.21739261241778057	   0.25844091576639583	   0.30126490356158303	   0.34819149204341271	   0.40038964715155650	   0.45827343139005100	   0.52182269552356741	   0.59079488055932405	   0.66482696818242282	   0.74345267144127214	   0.82608255433938660	    1.0061742030452738	    1.2003439556231024	    1.3957900100574989	    1.5829356166115893	    1.7492918255232794	    1.9099336677594292	;
  0.035216278604248093	   0.15563864850483217	   0.21194686830313961	   0.26522310346694700	   0.32285114444186669	   0.38043911392692048	   0.43983333592677182	   0.50337471662588296	   0.57253810444291953	   0.64793707528604050	   0.72960186637952096	   0.81725398640972524	   0.91035067211885423	    1.0080230614611123	    1.2190918091194975	    1.4408521720005230	    1.6592152585338726	    1.8670514017287370	    2.0596477205894357	    2.2463662229963255	;
  0.034751114668917844	   0.18344902290240658	   0.25548800823885293	   0.32158854576760215	   0.38869503272564554	   0.45812762597305423	   0.52992740140339434	   0.60532809792528997	   0.68608389175327422	   0.77354260002153241	   0.86822165631277926	   0.97006431513478542	    1.0784322174308429	    1.1919986058926177	    1.4356139490714992	    1.6834636004926291	    1.9232790181113220	    2.1528012924026005	    2.3725523245244209	    2.5876141446371195	;
  0.029301926215835328	   0.20477833507349852	   0.28955266445150574	   0.37182227265732687	   0.45332608780533173	   0.53594531915179888	   0.62047929395046164	   0.70785426110578664	   0.79997767176831902	   0.89924704520495002	    1.0072206165758217	    1.1240327489804074	    1.2484709400062448	    1.3785956535727715	    1.6563785099975821	    1.9277710896660876	    2.1885713713329173	    2.4420024392761475	    2.6905022084788404	    2.9362406427512409	;
  0.020444919586711387	   0.22208213649291508	   0.32075628603520440	   0.41854471464890791	   0.51592112287674829	   0.61377929901455697	   0.71274067766976734	   0.81314635601336027	   0.91648927381865597	    1.0264899817197384	    1.1480076789081908	    1.2809313437548542	    1.4215431520897877	    1.5684456636661908	    1.8808644900202816	    2.1724611978361565	    2.4554306211076700	    2.7360591106560599	    3.0160295100699304	    3.2952334971535433	;
  0.010710450859742206	   0.23858204126420204	   0.35147497852018700	   0.46417018397997073	   0.57722424002094919	   0.69133280365581695	   0.80654177941687610	   0.92268758602113987	    1.0391043720765272	    1.1587736997194880	    1.2939429373220150	    1.4435853863808084	    1.5985088345082141	    1.7629875054638386	    2.1055305214311422	    2.4155482008203686	    2.7242661609941510	    3.0363998356333561	    3.3516128231030033	    3.6678305039230392	;
 0.0033192341307759846	   0.25671170586240322	   0.38349621177069126	   0.51050442479594571	   0.63837409165596704	   0.76871518731511312	   0.90004418741214753	    1.0347340837732122	    1.1696591158823080	    1.3068006940299768	    1.4536115487476391	    1.6114586955952874	    1.7813244109918607	    1.9654205870207242	    2.3208496841831390	    2.6555813392003991	    2.9959041944307194	    3.3446153186921839	    3.6996515413356272	    4.0573388514987645	;
 0.0018277070391766971	   0.27818406404936047	   0.41818615120180508	   0.55915170813372661	   0.70145060645572666	   0.84633927983203838	   0.99213711299705065	    1.1422580871176966	    1.2965665686099810	    1.4519439446532216	    1.6070713976837325	    1.7702618588020014	    1.9473111399630438	    2.1356612777238215	    2.5209289246262734	    2.8935101335868425	    3.2716283271719102	    3.6624536457075392	    4.0624481854764216	    4.4669747615647450	;
 0.0097638907639918185	   0.30447322140936839	   0.45625432298630819	   0.61054280112765091	   0.76705630389387491	   0.92405731547015491	    1.0809402412297227	    1.2410700168583433	    1.4090224270453453	    1.5785258495736330	    1.7444408172441486	    1.9181838544549086	    2.1049187330336538	    2.3033929818004113	    2.7200613035372432	    3.1324110741916042	    3.5531622198533928	    3.9918087509438336	    4.4422126589025019	    4.8997144215410122	;
  0.030068642070991278	   0.33741902799443618	   0.49809585171774345	   0.66273001642077434	   0.83068494195142328	    1.0000959989471150	    1.1687755570674954	    1.3396277335413138	    1.5186633175852147	    1.7014123040532951	    1.8818958212217098	    2.0686377564783713	    2.2680879851528126	    2.4803053929824976	    2.9257664584664278	    3.3763614354133176	    3.8431990588061189	    4.3346740995753388	    4.8411453446468729	    5.3581236800736924	;
  0.064257830871526561	   0.37950393579732755	   0.54529728139644540	   0.71665075418375579	   0.89395757607920756	    1.0757974425145531	    1.2568802869148770	    1.4389967468449474	    1.6284984714382928	    1.8232791112121276	    2.0193027019581420	    2.2221237289316034	    2.4374517691259907	    2.6645062131512249	    3.1396248323383142	    3.6297305718959731	    4.1458473816624029	    4.6929092919433062	    5.2616673967810739	    5.8441257331950833	;
   0.11159331702876069	   0.46356974709061005	   0.61139568026514723	   0.77546877487483457	   0.95969613587956926	    1.1529388684244921	    1.3462949940095337	    1.5411694082101413	    1.7417084317702827	    1.9469249076903115	    2.1546876480959773	    2.3735530842478529	    2.6073968413750030	    2.8525827072611403	    3.3618790401681915	    3.8971335655026786	    4.4668487367016398	    5.0711861599264694	    5.7067448478565721	    6.3586924459529550	;
   0.18562769052265204	   0.59378878221095266	   0.71571002884867718	   0.85313942822304223	    1.0267799596667551	    1.2255647809433745	    1.4342318343063609	    1.6447125319394069	    1.8586829870593600	    2.0755621548129461	    2.2951412349732054	    2.5274593655990447	    2.7757878835333103	    3.0406940054750877	    3.5918597864536239	    4.1837368904372028	    4.8132288209316210	    5.4742378083613072	    6.1798602052314342	    6.9015552396230246	;
   0.34421273747285541	   0.77727625718815074	   0.87502619050640829	   0.98336288191996835	    1.1197619696942671	    1.3064264876416365	    1.5199024245835440	    1.7419944950267321	    1.9738638021227368	    2.2051290493474296	    2.4374156210019171	    2.6831837371989993	    2.9458590686231951	    3.2281119324847771	    3.8298735909770394	    4.4954622163172919	    5.1923358950242928	    5.9078323587694683	    6.6846369096284652	    7.4709616538813837	;
   0.54020297351481161	    1.0076901317476272	    1.1009585829023920	    1.2106496997989411	    1.3234673949640556	    1.4522723005433626	    1.6217800234433437	    1.8400541391160505	    2.0843727959864808	    2.3337575966337165	    2.5842341047542985	    2.8457770238349140	    3.1239391208701179	    3.4206579750650352	    4.0869898956259370	    4.8385029534594670	    5.6097803490862406	    6.3815078333046298	    7.2235695143077612	    8.0637039827023997	;
   0.73552674299537446	    1.2654256183216577	    1.3746665141945698	    1.5274410477239910	    1.6761575194673657	    1.7612589921158739	    1.8506160788446746	    2.0015049518826511	    2.2253748984600414	    2.4822925869323158	    2.7504951407242393	    3.0254288080466822	    3.3180248829649450	    3.6318806965848944	    4.3791337436213134	    5.2172525731147594	    6.0661613039893414	    6.9127662571552815	    7.7953255784135393	    8.6757125445136296	;
   0.90770596147254268	    1.5324116873002540	    1.6553313166758430	    1.8420947723060310	    1.9998310983706662	    2.1224745538229217	    2.1915294723785426	    2.2925769318741422	    2.4530469734734308	    2.6837924597205998	    2.9523489935309994	    3.2320282654980694	    3.5371981619855908	    3.8793201328010456	    4.7213301314658196	    5.6319303381604398	    6.5540016998276505	    7.4771422665406009	    8.3918554889307480	    9.3030921510615450	;
    1.0532027552856351	    1.7893079688624061	    1.9104264182725048	    2.0583526314440546	    2.2264593085727817	    2.3888145769318339	    2.5234883361874747	    2.6599250137377961	    2.8248900487309800	    3.0148283009701098	    3.2309196214248956	    3.4937131909105905	    3.8182791245289649	    4.2216080329597530	    5.1248396516711727	    6.0766908216304154	    7.0611749894938498	    8.0570865220233969	    9.0014608813211598	    9.9421443030618253	;
    1.1891132511026350	    1.9906249784048831	    2.1079939480111771	    2.2569518044031418	    2.4304500733325822	    2.6000291338980994	    2.7481534369245875	    2.9127602480114825	    3.1213044945451727	    3.3368652935361145	    3.5537829846760753	    3.8421026286291489	    4.2117527693648231	    4.6631820832039610	    5.5686272303587154	    6.5414587454568620	    7.5754726492747793	    8.6337415964396946	    9.6125768699389518	    10.589485275290563	;
    1.3185643482226623	    2.1843494045315421	    2.2979940601939224	    2.4488683262862128	    2.6308681923893102	    2.8160121886118588	    2.9891210465062055	    3.1762227614933223	    3.3971409042479483	    3.6432968842448981	    3.9006915672871885	    4.2330505998062442	    4.6328263959270659	    5.0738598041996870	    6.0107249625587427	    7.0166313765150807	    8.0884670822923539	    9.1820620343058827	    10.217636469775842	    11.242065526692961	;
    1.4417874948261149	    2.3727412046483956	    2.4846437142741897	    2.6404715240594192	    2.8354719817977028	    3.0397141607598579	    3.2337457269109202	    3.4396115904265092	    3.6804528262313965	    3.9592176506948875	    4.2558720475716880	    4.6264838932435595	    5.0480905549173176	    5.4924586183157258	    6.4553654304236705	    7.4953877308781278	    8.5977753871324811	    9.7212359306588496	    10.815915840195375	    11.897009978345029	;
    1.5612700331274183	    2.5601799790400830	    2.6724054385623273	    2.8354727456276860	    3.0452545235111974	    3.2681016926241835	    3.4805032360179013	    3.7061234154259148	    3.9722919777968935	    4.2829159912957131	    4.6114878675935547	    5.0134810098519704	    5.4583556379090759	    5.9182377576217808	    6.9044935817438375	    7.9746242976842669	    9.1042388306495710	    10.258983816502946	    11.409926177671593	    12.552452674076362	;
    1.6918616520026040	    2.7683928872270016	    2.8817554703109778	    3.0533188228173698	    3.2791317106942328	    3.5212419783415916	    3.7529594583211661	    4.0011036780516998	    4.2960998892620097	    4.6397666611003263	    4.9983924101644499	    5.4315431006572386	    5.9039046972878051	    6.3856551022714543	    7.3980033713885485	    8.4973750869308500	    9.6555003092483265	    10.846336622172528	    12.056273849436030	    13.267603933781441	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('LMDV_TIER_3_REG');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     60.737457969402662	    60.737457969402662		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
